module('lively.morphic.tools.LoadingIndicator').requires('lively.persistence.BuildSpec').toRun(function() {

m=lively.BuildSpec('lively.morphic.LoadingIndicator', {
    _FixedPosition: true,
    _Extent: lively.pt(128.0,128.0),
    _Fill: Color.rgba(131,131,131,0.95),
    className: "lively.morphic.Image",
    droppingEnabled: false,
    isEpiMorph: true,
    name: "LoadingIndicator",
    sourceModule: "lively.morphic.Widgets",
    submorphs: [{
        _Align: "center",
        _ClipMode: "hidden",
        _Extent: lively.pt(128.0,21.0),
        _FontFamily: "Arial, sans-serif",
        _FontSize: 11,
        _HandStyle: "default",
        _InputAllowed: false,
        _Padding: lively.rect(5,5,0,0),
        _Position: lively.pt(0.0,52.0),
        _TextColor: Color.rgb(255,255,255),
        _WhiteSpaceHandling: "pre",
        className: "lively.morphic.Text",
        eventsAreIgnored: true,
        isLabel: true,
        name: "Text",
        sourceModule: "lively.morphic.TextCore",
        textString: "Loading..."
    }],
    url: "data:image/gif;base64,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",
    onFromBuildSpecCreated: function onFromBuildSpecCreated() {
        $super();
        this.whenOpenedInWorld(function() {
            this.setPositionCentered(this.world().visibleBounds().extent().scaleBy(0.5));
        });
    },
});

Object.extend(lively.morphic.tools.LoadingIndicator, {
    open: function(doFunc) {
        var loadingIndicator = lively.BuildSpec('lively.morphic.LoadingIndicator').createMorph().openInWorld();
        function closeLoadingIndicator() { loadingIndicator.remove(); }
        doFunc && doFunc(closeLoadingIndicator);
        return loadingIndicator;
    }
});

}) // end of module