/*
 * @package jsDAV
 * @subpackage DAV
 * @copyright Copyright(c) 2011 Ajax.org B.V. <info AT ajax DOT org>
 * @author Mike de Boer <info AT mikedeboer DOT nl>
 * @license http://github.com/mikedeboer/jsDAV/blob/master/LICENSE MIT License
 */
"use strict";

var jsDAV_iNode = require("./iNode");

var Exc = require("./../../shared/exceptions");

/**
 * Implement this class to support locking
 */
var jsDAV_iLockable = module.exports = jsDAV_iNode.extend({
    /**
     * Returns an array with locks currently on the node
     *
     * @return jsDAV_Locks_LockInfo[]
     */
    getLocks: function(callback) { callback(Exc.notImplementedYet()); },

    /**
     * Creates a new lock on the file.
     *
     * @param {jsDAV_Locks_LockInfo} lockInfo The lock information
     * @return void
     */
    lock: function(lockInfo, callback) { callback(Exc.notImplementedYet()); },

    /**
     * Unlocks a file
     *
     * @param {jsDAV_Locks_LockInfo} lockInfo The lock information
     * @return void
     */
    unlock: function(lockInfo, callback) { callback(Exc.notImplementedYet()); }
});
