/*
 * @package jsDAV
 * @subpackage DAV
 * @copyright Copyright(c) 2011 Ajax.org B.V. <info AT ajax DOT org>
 * @author Mike de Boer <info AT mikedeboer DOT nl>
 * @license http://github.com/mikedeboer/jsDAV/blob/master/LICENSE MIT License
 */
"use strict";

var jsDAV_iNode = require("./iNode");

var Exc = require("./../../shared/exceptions");

/**
 * iProperties interface
 *
 * Implement this interface to support custom WebDAV properties requested and sent from clients.
 */
var jsDAV_iProperties = module.exports = jsDAV_iNode.extend({
    /**
     * Updates properties on this node,
     *
     * The properties array uses the propertyName in clark-notation as key,
     * and the array value for the property value. In the case a property
     * should be deleted, the property value will be null.
     *
     * This method must be atomic. If one property cannot be changed, the
     * entire operation must fail.
     *
     * If the operation was successful, true can be returned.
     * If the operation failed, false can be returned.
     *
     * Deletion of a non-existant property is always succesful.
     *
     * Lastly, it is optional to return detailed information about any
     * failures. In this case an array should be returned with the following
     * structure:
     *
     * {
     *   "403": {
     *      "{DAV:}displayname": null
     *   },
     *   "424": {
     *      "{DAV:}owner": null
     *   }
     * }
     *
     * In this example it was forbidden to update {DAV:}displayname.
     * (403 Forbidden), which in turn also caused {DAV:}owner to fail
     * (424 Failed Dependency) because the request needs to be atomic.
     *
     * @param {Object} properties
     * @return bool|array
     */
    updateProperties: function(properties, callback) { callback(Exc.notImplementedYet()); },

    /**
     * Returns a list of properties for this nodes.
     *
     * The properties list is a list of propertynames the client requested,
     * encoded in clark-notation {xmlnamespace}tagname
     *
     * If the array is empty, it means 'all properties' were requested.
     *
     * @param {Object} properties
     * @return void
     */
    getProperties: function(properties, callback) { callback(Exc.notImplementedYet()); }
});
