# restify

[![Build Status](https://travis-ci.org/mcavage/node-restify.png)](https://travis-ci.org/mcavage/node-restify)

[restify](http://mcavage.github.com/node-restify) is a smallish framework,
similar to [express](http://expressjs.com) for building REST APIs.  For full
details, see http://mcavage.github.com/node-restify.

# Usage

## Server

    var restify = require('restify');

    var server = restify.createServer({
      name: 'myapp',
      version: '1.0.0'
    });
    server.use(restify.acceptParser(server.acceptable));
    server.use(restify.queryParser());
    server.use(restify.bodyParser());

    server.get('/echo/:name', function (req, res, next) {
      res.send(req.params);
      return next();
    });

    server.listen(8080, function () {
      console.log('%s listening at %s', server.name, server.url);
    });

## Client

    var assert = require('assert');
    var restify = require('restify');

    var client = restify.createJsonClient({
      url: 'http://localhost:8080',
      version: '~1.0'
    });

    client.get('/echo/mark', function (err, req, res, obj) {
      assert.ifError(err);
      console.log('Server returned: %j', obj);
    });

# Installation

    $ npm install restify

## License

The MIT License (MIT)
Copyright (c) 2012 Mark Cavage

Permission is hereby granted, free of charge, to any person obtaining a copy of
this software and associated documentation files (the "Software"), to deal in
the Software without restriction, including without limitation the rights to
use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
the Software, and to permit persons to whom the Software is furnished to do so,
subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.

## Bugs

See <https://github.com/mcavage/node-restify/issues>.

## Mailing list

See the
[Google group](https://groups.google.com/forum/?hl=en&fromgroups#!forum/restify)
.
